<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Dtos\Post;

use Erlage\Photogram\Data\Dtos\AbstractDTO;
use Erlage\Photogram\Data\Dtos\Traits\TraitStringMapDTO;
use Erlage\Photogram\Data\Dtos\Traits\TraitComplaintValidatorDTO;
use Erlage\Photogram\Data\Dtos\Traits\TraitComplaintTransformerDTO;

final class PostMetaHashtagsDTO extends AbstractDTO
{
    /**
     * string map DTO
     */
    use TraitStringMapDTO;
    /**
     * to comply with DTO interface
     */
    use TraitComplaintValidatorDTO;
    use TraitComplaintTransformerDTO;

    private $iteratorKey = 0;

    private $iteratorKeyToLiteralMap = array();

    private $iteratorKeyToIdMap = array();

    public function iteratorPrepare(): void
    {
        $this -> iteratorKey = -1;

        $this -> iteratorKeyToLiteralMap = \array_keys($this -> entries);
        $this -> iteratorKeyToIdMap = \array_values($this -> entries);
    }

    public function iteratorForward(): bool
    {
        if (isset($this -> iteratorKeyToLiteralMap[$this -> iteratorKey + 1]))
        {
            $this -> iteratorKey++;

            return true;
        }

        return false;
    }

    public function iteratorCurrentHashtagLiteral(): string
    {
        return $this -> iteratorKeyToLiteralMap[$this -> iteratorKey];
    }

    public function iteratorCurrentHashtagId(): string
    {
        return $this -> iteratorKeyToIdMap[$this -> iteratorKey];
    }
}
